﻿#include "precompiled.h"
#include "common.h"
#include "Aperture.h"

const float kSmallestFNumber = 2;
const float kLargestFNumber = 64;
const float kInitialFNumber = 16;

namespace RTCam {

Aperture::Aperture(void) :
	m_minFNumber(kSmallestFNumber),
	m_maxFNumber(kLargestFNumber),
	m_curFNumber(kInitialFNumber)
{
}

Aperture::~Aperture(void)
{
}

float Aperture::ValidateFNumber(float fNumber)
{
	return Clamp(fNumber, m_minFNumber, m_maxFNumber);
}

float Aperture::GetFNumber()
{
	return m_curFNumber;
}

void Aperture::SetFNumber(float fNumber)
{
	m_curFNumber = ValidateFNumber(fNumber);
}

void Aperture::SetFNumberRange( float minFNumber, float maxFNumber )
{
	m_minFNumber = minFNumber;
	m_maxFNumber = maxFNumber;
}

} // end namespace